/*
 * Decompiled with CFR 0.152.
 */
package woodchuck;

import groovy.lang.GroovyClassLoader;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import woodchuck.WoodChuckConverter;

public class WoodChuck {
    static WoodChuckConverter Converter = null;

    public static void main(String[] args) {
        File[] possibles;
        Object gc = WoodChuck.LoadGroovyClass("converter.groovy");
        if (gc instanceof WoodChuckConverter) {
            Converter = (WoodChuckConverter)gc;
        } else {
            WoodChuck.Die("converter.groovy is broken. Is it not an implementation of WoodChuckConverter?");
        }
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int returnVal = fc.showOpenDialog(null);
        File dir = fc.getSelectedFile();
        for (File f : possibles = dir.listFiles()) {
            String name = f.getName();
            name.toLowerCase();
            if (!name.endsWith(".log")) continue;
            WoodChuck.Convert(f.getPath());
        }
    }

    public static Object LoadGroovyClass(String fname) {
        GroovyClassLoader gcl = new GroovyClassLoader();
        try {
            Class clazz = gcl.parseClass(new File(fname));
            return clazz.newInstance();
        }
        catch (Exception e) {
            WoodChuck.Die("LoadGroovyClass() exception: " + e.getLocalizedMessage());
            return null;
        }
    }

    public static void Convert(String fname) {
        try {
            String strLine;
            if (!Converter.StartConversion(fname)) {
                return;
            }
            FileInputStream fstream = new FileInputStream(fname);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            int ln = 0;
            while ((strLine = br.readLine()) != null && Converter.ConvertLine(ln++, strLine)) {
            }
            in.close();
            Converter.EndConversion();
        }
        catch (Exception e) {
            WoodChuck.Die("Convert() exception: " + e.getLocalizedMessage());
        }
    }

    public static void Die(String s) {
        JOptionPane.showMessageDialog(null, s, "Woodchuck Fatal", 0);
        System.exit(-1);
    }
}

