/*
  This is the actual converter code used by WoodChuck,
  its here in the open so end users can adjust and alter
  it as they see fit. It also means that WoodChuck does
  not end up being a one-trick pony. - JasonP
  
  This class implements three functions from interface
  WoodChuckConverter:
    
    public boolean StartConversion(String FileName);
      - This is called when a conversion of a file is
      about to start.
    public boolean EndConversion();
      - This is called once the converstion is complete.
    public boolean ConvertLine(int LineNumber, String InputLine);
      - This is called for each line that WoodChuck reads in,
      and you have the converter do whatever with it as you like.
      You should note that the newline is stripped off the
      InputLine provided here.
      
   Below is a simple converter designed to work on Tom's
   log files he provided, but it could be adapted to work
   any format.
   
   I claim no particular rights to any of this, see LICENSE.TXT
   for the MIT style license I've placed on it.
   
   Jason A. Petrasko
*/

// some imports
import woodchuck.WoodChuckConverter;
import java.io.*;
import java.util.regex.*;

// the actual class
class converter implements WoodChuckConverter
{
    String SourceFile = null;
    BufferedWriter Writer = null;
    // regex stuff
    Pattern rpWord = null;
    
    // ok lets get setup
    public boolean StartConversion(String FileName)
    {
      // store file details and open an output writer
      SourceFile = FileName;
      Writer = new BufferedWriter(new FileWriter(SourceFile + ".txt"));
      
      // setup regex
      rpWord = Pattern.compile("\\w+");
      
      return true;
    }
    
    // close the output file, we are all done
    public boolean EndConversion()
    {
      Writer.close();
      return true;
    }

    // we do the conversion here
    public boolean ConvertLine(int LineNumber, String InputLine)
    {
      Matcher matcher = rpWord.matcher(InputLine);
      Writer.write(matcher.replaceAll("*"));
      Writer.newLine();
      return true;
    }
    
}
